<?php
include '../db.php';

// =============== Tambah tamu
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['tambah'])) {
    $nama  = $_POST['nama'] ?? '';
    $no_hp = $_POST['no_hp'] ?? '';
    $token = uniqid();

    $stmt = $pdo->prepare("INSERT INTO tamu (nama, no_hp, url_token) VALUES (?, ?, ?)");
    $stmt->execute([$nama, $no_hp, $token]);
    header("Location: tamu.php");
    exit;
}

// =============== Hapus tamu
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $pdo->prepare("DELETE FROM tamu WHERE id=?")->execute([$id]);
    header("Location: tamu.php");
    exit;
}

// =============== Edit tamu
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update'])) {
    $id    = $_POST['id'];
    $nama  = $_POST['nama'];
    $no_hp = $_POST['no_hp'];

    $stmt = $pdo->prepare("UPDATE tamu SET nama=?, no_hp=? WHERE id=?");
    $stmt->execute([$nama, $no_hp, $id]);
    header("Location: tamu.php");
    exit;
}

$tamuList = $pdo->query("SELECT * FROM tamu ORDER BY id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Tamu</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <!-- DataTables Bootstrap 5 -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
</head>

<body class="bg-light">

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="index.php">📋 Buku Tamu</a>
        </div>
    </nav>

    <div class="container py-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="fw-bold">Kelola Tamu</h2>
            <div class="d-flex gap-2">
                <a href="index.php" class="btn btn-outline-primary btn-sm">
                    <i class="bi bi-arrow-left-circle"></i> Kembali
                </a>
                <button class="btn btn-outline-secondary btn-sm" onclick="printTable()">
                    <i class="bi bi-printer"></i> Print Tabel
                </button>
            </div>
        </div>

        <!-- Form Tambah -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <i class="bi bi-person-plus"></i> Tambah Tamu
            </div>
            <div class="card-body">
                <form method="post" class="row g-3">
                    <div class="col-md-5">
                        <input type="text" name="nama" class="form-control" placeholder="Nama Tamu" required>
                    </div>
                    <div class="col-md-5">
                        <input type="text" name="no_hp" class="form-control" placeholder="No HP">
                    </div>
                    <div class="col-md-2 d-grid">
                        <button type="submit" name="tambah" class="btn btn-primary">
                            <i class="bi bi-plus-circle"></i> Tambah
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Daftar Tamu -->
        <div class="card shadow-sm">
            <div class="card-header bg-success text-white">
                <i class="bi bi-people"></i> Daftar Tamu
            </div>
            <div class="card-body table-responsive">
                <table class="table table-striped align-middle" id="tamuTable">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Nama</th>
                            <th>No HP</th>
                            <th>Link</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($tamuList as $t): ?>
                        <tr>
                            <td><?= $t['id'] ?></td>
                            <td>
                                <?php if (isset($_GET['edit']) && $_GET['edit'] == $t['id']): ?>
                                <form method="post" class="d-flex gap-2">
                                    <input type="hidden" name="id" value="<?= $t['id'] ?>">
                                    <input type="text" name="nama" class="form-control" value="<?= htmlspecialchars($t['nama']) ?>">
                                    <?php else: ?>
                                    <?= htmlspecialchars($t['nama']) ?>
                                    <?php endif; ?>
                            </td>
                            <td>
                                <?php if (isset($_GET['edit']) && $_GET['edit'] == $t['id']): ?>
                                <input type="text" name="no_hp" class="form-control" value="<?= htmlspecialchars($t['no_hp']) ?>">
                                <?php else: ?>
                                <?= htmlspecialchars($t['no_hp']) ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-outline-secondary" onclick="copyLink('<?= 'undangan.pncr-tech.com/undangan-tian/undangan.php?id=' . $t['id'] . '&token=' . $t['url_token'] ?>')" title="Copy Link">
                                    <i class="bi bi-clipboard"></i>
                                </button>
                            </td>
                            <td class="text-center">
                                <?php if (isset($_GET['edit']) && $_GET['edit'] == $t['id']): ?>
                                <button type="submit" name="update" class="btn btn-sm btn-success">
                                    <i class="bi bi-save"></i>
                                </button>
                                </form>
                                <?php else: ?>
                                <a href="tamu.php?edit=<?= $t['id'] ?>" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="tamu.php?delete=<?= $t['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Hapus tamu ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Script -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
    // aktifkan DataTable
    $(document).ready(function() {
        $('#tamuTable').DataTable({
            "pageLength": 10,
            "lengthMenu": [5, 10, 25, 50, 100],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.8/i18n/id.json"
            }
        });
    });

    function copyLink(link) {
        navigator.clipboard.writeText(link).then(() => {
            alert("Link berhasil disalin!");
        }).catch(err => {
            alert("Gagal menyalin link: " + err);
        });
    }

    function printTable() {
        var table = document.getElementById("tamuTable").cloneNode(true);
        table.querySelectorAll("tr th:nth-child(4), tr th:nth-child(5)").forEach((th, idx) => {
            if (idx === 0) {
                th.innerText = "TTD";
            } else {
                th.remove();
            }
        });
        table.querySelectorAll("tr").forEach((row, i) => {
            if (i === 0) return;
            let cells = row.querySelectorAll("td");
            if (cells.length >= 5) {
                cells[3].innerText = "";
                cells[4].remove();
            }
        });
        var tableHTML = table.outerHTML;
        var win = window.open("", "_blank", "width=900,height=700");
        win.document.open();
        win.document.write(`
                <html>
                <head>
                    <title>Print Tabel</title>
                    <style>
                        body { font-family: Arial, sans-serif; margin:20px; }
                        h2 { text-align:center; margin-bottom:20px; }
                        table { border-collapse: collapse; width: 100%; font-size: 12px; }
                        th, td { border: 1px solid #ccc; padding: 6px; text-align: left; }
                        th { background: #f2f2f2; }
                        td { height: 40px; }
                    </style>
                </head>
                <body>
                    <h2>Daftar Tamu</h2>
                    ${tableHTML}
                </body>
                </html>
            `);
        win.document.close();
        win.onload = function() {
            win.focus();
            win.print();
            win.close();
        };
    }
    </script>
</body>

</html>